function [ S2 ] = Assemble_Space( orig_delta,r,d,B )
%Assemble the spce matrix of Galerkin in S^r_d over interval.
%   Integrate the stiffness matrix associated to space part of the Galerkin
%   approximation.  That is given A(x)u_t - [B(x)u(x)]' = 0, compute
%   \int^b_a{N'_i*B(x)*N'_j}dx for i,j ranging over the S^r_d normalized
%   B-spline basis.  B(x) is the function handle expressing the space
%   coefficient. orig_delta is the UNextended knot sequence.

%Number of elements
nelm = size(orig_delta,2)-1;

%Extended paritions for computing product basis splines
[extdelta,n] = extpar(orig_delta,r,d);
[extdeltad,nd] = extpar(orig_delta,r-1,d-1);

%Extract the weights to be used
[w,rq,sq] = quadset(6);

%Extract the coefficients of derivatives of basis splines but on S^rm1_dm1
%basis
In = eye(n);                                    %To express basis splines                            
Derivs = zeros(n,nd);
for i=1:n
    [~,Derivs(i,:),~] = derspl(d,extdelta,In(i,:));
end

%Assemble Stiffness Matrix
S2 = zeros(n,n);
for i=1:n
    for j=1:n
        for k=1:nelm %For this pair of basis elements cycle over all elements
            %Extract weight sample points
            bk = orig_delta(1,k+1);
            ak = orig_delta(1,k);
            sample = ak*rq+bk*sq;
            
            %Evaluate Coefficient and Basis Splines at samples
            vali = sval2(d-1,extdeltad,nd,Derivs(i,:),sample); 
            valj = sval2(d-1,extdeltad,nd,Derivs(j,:),sample);
            valb = arrayfun(B,sample);
            
            S2(i,j) = S2(i,j) + (bk-ak)/2*sum(w.*vali.*valj.*valb); %Schumaker (1.62)
        end
    end
end

end

